import React from "react";
import Link from "next/link";
export default function SinglePost() {
  return (
    <div>
      <main className="content">
        <div
          className="section-main-screen section-main-screen_inner"
          style={{ backgroundImage: `url(img/bg/header.svg)` }}
        >
          <div className="wrapper">
            <div className="main-screen main-screen_inner">
              <div className="h1 h1-2">Post</div>
              <ul
                className="breadcrumbs"
                itemScope=""
                itemType="https://schema.org/BreadcrumbList"
              >
                <li
                  itemProp="itemListElement"
                  itemScope=""
                  itemType="https://schema.org/ListItem"
                >
                  <a href="#" itemProp="item">
                    <span itemProp="name">Home</span>
                  </a>
                  <meta itemProp="position" content="1" />
                </li>
                <li
                  itemProp="itemListElement"
                  itemScope=""
                  itemType="https://schema.org/ListItem"
                >
                  <a href="#" itemProp="item">
                    <span itemProp="name">Blog</span>
                  </a>
                  <meta itemProp="position" content="2" />
                </li>
              </ul>
              <div className="leaf-left-decor"></div>
            </div>
            <div className="circle-decor"></div>
          </div>
          <div className="leaf-right-decor"></div>
        </div>
        <div className="section-post section-post-inner">
          <div className="wrapper">
            <div className="columns">
              <div className="columns_center">
                <article className="article-wrap">
                  <div className="article">
                    <picture>
                      <source
                        type="image/jpeg"
                        srcSet="img/examples/article.jpg"
                        media="(min-width: 768px)"
                      />
                      <source
                        type="image/jpeg"
                        srcSet="img/examples/article_mob.jpg"
                      />
                      <img
                        src="img/examples/article_mob.jpg"
                        alt=""
                        className="img-article-main"
                      />
                    </picture>
                    <div className="news-header news-header_article">
                      <div className="news__date">Jun 25, 2021</div>
                      <div className="news__author">
                        <img
                          data-src="img/examples/avatar_2.jpg"
                          alt=""
                          className="js-lazy"
                          src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        />
                        {/* <span className="news__author-title">
                          Annette Black
                        </span> */}
                      </div>
                    
                    </div>
                    
                    <blockquote>
                      “As a participatory media culture, social media platforms
                      or social networking sites are forms of mass communication
                      that, through media technologies, allow large amounts of
                      product and distribution of content to reach the largest
                      audience possible. “<cite>جیب جیب</cite>
                    </blockquote>
                  
                  </div>
                  <div className="tags-article">
                    <div className="tags-article__title">Tags:</div>
                    <div className="tags">
                      <a href="blog.html" className="tags__item">
                        Technology
                      </a>
                      <a href="blog.html" className="tags__item">
                        Office
                      </a>
                      <a href="blog.html" className="tags__item">
                        Mobile
                      </a>
                    </div>
                  </div>
                </article>
              </div>
              <aside className="columns_sidebar sidebar">
                <div className="sidebar_search">
                  <form>
                    <div className="search">
                      <input type="text" placeholder="جستجو ...." />
                      <button type="submit">
                        <span className="icon-search"></span>
                      </button>
                    </div>
                  </form>
                </div>
                <div className="sidebar-widget sidebar-widget_post">
                  <h3 className="sidebar-widget__title">پست های اخیر</h3>
                  <div className="stories">
                    <div className="stories-item">
                      <a href="article.html" className="stories-item__img">
                        <img
                          data-src="img/examples/img1.jpg"
                          src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                          className="js-lazy"
                          alt=""
                        />
                      </a>
                      <div className="stories-item__infoline">
                        <div className="stories-item__title">
                          <a href="article.html">
                            How the Victorian fashion came to be
                          </a>
                        </div>
                        <div className="stories-item__date">Jun 25, 2021</div>
                      </div>
                    </div>
                    <div className="stories-item">
                      <a href="article.html" className="stories-item__img">
                        <img
                          data-src="img/examples/img2.jpg"
                          src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                          className="js-lazy"
                          alt=""
                        />
                      </a>
                      <div className="stories-item__infoline">
                        <div className="stories-item__title">
                          <a href="article.html">
                            How the Victorian fashion came to be
                          </a>
                        </div>
                        <div className="stories-item__date">Jun 25, 2021</div>
                      </div>
                    </div>
                    <div className="stories-item">
                      <a href="article.html" className="stories-item__img">
                        <img
                          data-src="img/examples/img3.jpg"
                          src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                          className="js-lazy"
                          alt=""
                        />
                      </a>
                      <div className="stories-item__infoline">
                        <div className="stories-item__title">
                          <a href="article.html">
                            How the Victorian fashion came to be
                          </a>
                        </div>
                        <div className="stories-item__date">Jun 25, 2021</div>
                      </div>
                    </div>
                  </div>
                </div>
                <div className="sidebar-widget sidebar-widget_datepicker">
                  <div id="datepicker" className="datepicker"></div>
                </div>
                <div className="sidebar-widget sidebar-widget_gallery">
                  <h3 className="sidebar-widget__title">gallery</h3>
                  <div className="gallery">
                    <a
                      href="img/examples/gallery_1_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_1.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                    <a
                      href="img/examples/gallery_2_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_2.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                    <a
                      href="img/examples/gallery_3_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_3.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                    <a
                      href="img/examples/gallery_4_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_4.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                    <a
                      href="img/examples/gallery_5_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_5.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                    <a
                      href="img/examples/gallery_6_big.jpg"
                      className="gallery__item js-fancybox"
                      data-fancybox="gallery"
                    >
                      <img
                        data-src="img/examples/gallery_6.jpg"
                        src="data:image/gif;base64,R0lGODlhAQABAAAAACw="
                        className="js-lazy"
                        alt=""
                      />
                    </a>
                  </div>
                </div>
              </aside>
            </div>
          </div>
        </div>
      </main>
    </div>
  );
}
